%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%   Electric potential due to multiple charges


clear all;
close all;
EPS0 = 8.8542*10^(-12);

N = input('Enter the number of point charges: ');

X = zeros(1,N);
Y = zeros(1,N);
Z = zeros(1,N);
Q = zeros(1,N);

for i = 1:N
    X(i) = input(['Enter the X coordinate in meters for charge ',int2str(i) ,':  ']);
    Y(i) = input(['Enter the Y coordinate in meters for charge ', int2str(i),':  ']);
    Z(i) = input(['Enter the Z coordinate in meters for charge ', int2str(i),':  ']);
    Q(i) = input(['Enter the charge in coulombs for charge ', int2str(i),':  ']);
end

Px = input('Enter the X coordinate in meters of the point of interest: ');
Py = input('Enter the Y coordinate in meters of the point of interest: ');
Pz = input('Enter the Z coordinate in meters of the point of interest: ');
P = [Px, Py, Pz];

%distance between observation point and each charge
r = sqrt((Px - X).^2 + (Py - Y).^2 + (Pz - Z).^2);

% Potential computation
V = Q./(r.*4*pi*EPS0);
Vtot = sum(V,2);
fprintf('Resultant potential at point P is %f V.\n',Vtot);
